import numpy as np
import copy
from Box2D import b2_pi 


def generate_object_dicts(action_objects, max_action_radius, object_names, all_names, world_size, passive):
    object_sizes, object_range, object_dynamics, position_masks, object_instanced = (
        dict(),
        dict(),
        dict(),
        dict(),
        dict(),
    )
    position_range = world_size * 0.5
    # There are multiple 2D actions, one for each action object
    # For now unrolling into an integer, check if code supports vectors as object sizes
    object_sizes["Action"] = (
        1 if passive else 2 * len(action_objects)
    )
    object_range["Action"] = [np.array([0]), np.array([1])] if passive else [np.array([-position_range, 0] * len(action_objects)),
                                                                        np.array([position_range, max_action_radius] * len(action_objects))]
    object_dynamics["Action"] = [np.array([-1]), np.array([1])] if passive else [np.array([-position_range * 2, -0.1] * len(action_objects)),
                                                                        np.array([position_range * 2, 0.1] * len(action_objects))]
    for name in ["Reward", "Done"]:
        object_sizes[name] = 1
        object_range[name] = [
            np.array([-1]).astype(np.float64),
            np.array([1]).astype(np.float64),
        ]
        object_dynamics[name] = [
            np.array([-2]).astype(np.float64),
            np.array([2]).astype(np.float64),
        ]
        position_masks[name] = np.zeros(object_sizes[name])
    # Use the dataclass for the PHYRE object to get the number of attributes
    # Ignoring color and type, so subtracting two
    for n in ["Ball", "Target"]:
        if n in object_names:
            # x, y, velocity_x, velocity_y, angular_velocity, radius, dynamics
            object_sizes[n] = 7
            # TODO: tune velocity ranges based on observed values
            object_range[n] = [
                np.array(
                    [
                        -position_range,
                        -position_range,
                        -2 * position_range,
                        -2 * position_range,
                        -8,
                        0,
                        0,
                    ]
                ),
                np.array(
                    [
                        position_range,
                        position_range,
                        2 * position_range,
                        2 * position_range,
                        8,
                        5,
                        1,
                    ]
                ),
            ]
            object_dynamics[n] = [
                np.array(
                    [
                        -2 * position_range,
                        -2 * position_range,
                        -4 * position_range,
                        -4 * position_range,
                        -25,
                        -0.1,
                        0,
                    ]
                ),
                np.array(
                    [
                        2 * position_range,
                        2 * position_range,
                        4 * position_range,
                        4 * position_range,
                        25,
                        0.1,
                        1,
                    ]
                ),
            ]
            position_masks[n] = np.array([1, 1, 0, 0, 0, 0, 0])
    if "Platform" in object_names:
        # x, y, velocity_x, velocity_y, sin angle, cos_angle, angular_velocity, length, dynamic 
        object_range["Platform"] = [
            np.array(
                [
                    -position_range,
                    -position_range,
                    -2 * position_range,
                    -2 * position_range,
                    -1,
                    -1,
                    -8,
                    0,
                    0,
                ]
            ),
            np.array(
                [
                    position_range,
                    position_range,
                    2 * position_range,
                    2 * position_range,
                    1,
                    1,
                    8,
                    2 * position_range,
                    1,

                ]
            ),
        ]
        object_dynamics["Platform"] = [
            np.array(
                [
                    -2 * position_range,
                    -2 * position_range,
                    -4 * position_range,
                    -4 * position_range,
                    -2,
                    -2,
                    -8,
                    -0.1,
                    0,
                ]
            ),
            np.array(
                [
                    2 * position_range,
                    2 * position_range,
                    4 * position_range,
                    4 * position_range,
                    2,
                    2,
                    8,
                    0.1,
                    1,
                ]
            ),
        ]
        position_masks["Platform"] = np.array([1, 1, 0, 0, 0, 0, 0, 0, 0])
        object_sizes["Platform"] = 9
    if "Basket" in object_names:
        # x, y, velocity_x, velocity_y, sin angle, cos angle, angular_velocity, scale, dynamic
        object_sizes["Basket"] = 9
        object_range["Basket"] = [
            np.array(
                [
                    -position_range,
                    -position_range,
                    -2 * position_range,
                    -2 * position_range,
                    -1,
                    -1,
                    -3,
                    0.1,
                    0,
                ]
            ),
            np.array(
                [
                    position_range,
                    position_range,
                    2 * position_range,
                    2 * position_range,
                    1,
                    1,
                    3,
                    5,
                    1,
                ]
            ),
        ]
        object_dynamics["Basket"] = [
            np.array(
                [
                    -2 * position_range,
                    -2 * position_range,
                    -4 * position_range,
                    -4 * position_range,
                    -2,
                    -2,
                    -6,
                    -0.1,
                    0,
                ]
            ),
            np.array(
                [
                    2 * position_range,
                    2 * position_range,
                    2 * position_range,
                    2 * position_range,
                    2,
                    2,
                    6,
                    0.1,
                    1,
                ]
            ),
        ]
    position_masks["Basket"] = np.array([1, 1, 0, 0, 0, 0, 0, 0, 0])
    for name in all_names:
        oname = name.strip("0123456789") # TODO: come up with a better way of getting oname from name
        object_instanced[oname] = object_instanced[oname] + 1 if oname in object_instanced else 1
    # raise NotImplementedError(
    #     f"Object {name} not supported. Supported: Action, Reward, Done, Ball, Platform or Basket"
    # )
    object_range_true, object_dynamics_true = copy.deepcopy(object_range), copy.deepcopy(object_dynamics)
    return (
        object_sizes,
        object_range,
        object_dynamics,
        object_range_true,
        object_dynamics_true,
        position_masks,
        object_instanced,
    )
